"""Renames only files that can be renamed automatically."""

from file_organization_common import *
from pathlib import Path


def main():
    working_directory = 'data/tutorial/working'
    staging_directory = 'data/tutorial/staging'
    do_rename_and_stage_files(working_directory, staging_directory)


def do_rename_and_stage_files(working_directory, staging_directory):
    """
    Renames files in the working directory that can be renamed automatically and moves them to the staging directory.

    Args:
        working_directory: Can be either a Path object or a str object.
        staging_directory: Can be either a Path object or a str object.

    Returns:
        None.
    """
    working_directory_path = get_directory_path(working_directory)
    staging_directory_path = get_directory_path(staging_directory)
    file_count = 0
    renamed_and_staged_count = 0
    print(f'\nRenaming files in {working_directory_path} files that can be renamed automatically:')
    for item in sorted(working_directory_path.iterdir()):
        if item.is_file():
            file_count += 1
            name_parts = item.stem.split()
            if len(name_parts) == 4:
                project, description, contributor, sequence = name_parts
                new_filename = (f'{normalize(project)}_{normalize(contributor)}_'
                                f'{normalize(description)}_{normalize(sequence)}_'
                                f'{normalize(item.suffix)}')
                clone_file(item, staging_directory_path, new_filename)
                delete_file(item)
                renamed_and_staged_count += 1

    print(f'\tThere were {file_count} files in the directory.')
    print(f'{renamed_and_staged_count} files were renamed automatically and staged.')


def normalize(textin):
    result = textin.lower().replace('-', '_')
    return result


if __name__ == '__main__':
    main()
