"""Generates synthetic test data for exercise 1."""

from random import randint, choice
from file_organization_common import *


START_DATE = '2021-01-01'
END_DATE = '2022-12-31'
PROJECT_NAMES = ['INFOSEC-25', 'BATHWATER']
DATA_SOURCE = ['JR', 'MOMO', 'COLLABORATOR-C','COLLABORATOR-D']
FILE_SEQUENCE_START = 1


def get_random_data_source():
    return choice(DATA_SOURCE)


def get_random_project_name():
    return choice(PROJECT_NAMES)


def format_style_a_sequence_number(sequence_number):
    return f'S{sequence_number:04d}'


def format_style_b_sequence_number(sequence_number):
    return f'S{sequence_number}'


def get_random_american_date(starting_iso_date, ending_iso_date):
    iso_date = get_random_iso_date(starting_iso_date, ending_iso_date)
    american_date = f'{iso_date[5:7]}-{iso_date[8:10]}-{iso_date[0:4]}'
    return american_date


def get_random_european_date(starting_iso_date, ending_iso_date):
    iso_date = get_random_iso_date(starting_iso_date, ending_iso_date)
    european_date = f'{iso_date[8:10]}-{iso_date[5:7]}-{iso_date[0:4]}'
    return european_date


def get_random_iso_date(starting_iso_date, ending_iso_date):
    start_year, start_month, start_day = parse_iso_date(starting_iso_date)
    end_year, end_month, end_day = parse_iso_date(ending_iso_date)
    if start_year == end_year:
        random_year = start_year
    else:
        random_year = randint(start_year, end_year)
    random_month = randint(start_month, end_month)
    random_day = randint(1, determine_days_in_month(random_year, random_month))
    random_iso_date = f'{random_year:4}-{random_month:02d}-{random_day:02d}'
    return random_iso_date


def determine_days_in_month(the_year, the_month):
    if is_leap_year(the_year):
        february_days = 29
    else:
        february_days = 28
    if the_month in [4, 6, 9, 11]:
        max_days = 30
    elif the_month == 2:
        max_days = february_days
    else:
        max_days = 31
    return max_days


def is_leap_year(year):
    answer = False
    if (year % 4) == 0:
        if (year % 100) == 0:
            if (year % 400) == 0:
                answer = True
            else:
                answer = False
        else:
            answer = True
    else:
        answer = False
    return answer


def parse_iso_date(iso_date):
    year_as_string, month_as_string, day_as_string = iso_date.split('-')
    year = int(year_as_string)
    month = int(month_as_string)
    day = int(day_as_string)
    return year, month, day


def main():
    create_batch_directories()
    next_sequence_number = create_batch_1_files()
    batch_payload_directory = 'data/exercise_1/batch_1'
    delete_directory(batch_payload_directory)
    create_directory(batch_payload_directory)
    source_directory = 'data/__generate_synthetic_data/exercise_1/batch_1'
    zipfile_name = 'batch_1_data.zip'
    create_zipfile(source_directory, batch_payload_directory, zipfile_name)

    next_sequence_number = create_batch_2_files(next_sequence_number)
    batch_payload_directory = 'data/exercise_1/batch_2'
    delete_directory(batch_payload_directory)
    create_directory(batch_payload_directory)
    source_directory = 'data/__generate_synthetic_data/exercise_1/batch_2'
    zipfile_name = 'batch_2_data.zip'
    create_zipfile(source_directory, batch_payload_directory, zipfile_name)


def create_batch_directories():
    directory_name = 'data/exercise_1/batch_1'
    delete_directory(directory_name)
    create_directory(directory_name)
    directory_name = 'data/exercise_1/batch_2'
    delete_directory(directory_name)
    create_directory(directory_name)


def create_batch_1_files():
    batch_directory_name = 'data/__generate_synthetic_data/exercise_1/batch_1'
    delete_directory(batch_directory_name)
    create_directory(batch_directory_name)

    file_name = 'data/__generate_synthetic_data/template_files/readme.md'
    for project in PROJECT_NAMES:
        new_filename = f'{project} readme.md'
        clone_file(file_name, batch_directory_name, new_filename)

    file_name = 'data/__generate_synthetic_data/template_files/data_template.csv'
    new_filename = 'mangled_csv_filename.csv'
    clone_file(file_name, batch_directory_name, new_filename)

    file_name = 'data/__generate_synthetic_data/template_files/data_template.xml'
    new_filename = 'mangled_xml_filename.xml'
    clone_file(file_name, batch_directory_name, new_filename)

    file_name = 'data/__generate_synthetic_data/template_files/image_template.jp2'
    new_filename = 'mangled_image_filename.jp2'
    clone_file(file_name, batch_directory_name, new_filename)

    file_name = 'data/__generate_synthetic_data/template_files/template_notebook.ipynb'
    new_filename = 'mangled_notebook_filename.ipynb'
    clone_file(file_name, batch_directory_name, new_filename)

    file_name = 'data/__generate_synthetic_data/template_files/template_python_program.py'
    new_filename = 'mangled_python_program_name.py'
    clone_file(file_name, batch_directory_name, new_filename)

    sequence_number = 0
    for i in range(40):
        sequence_number += 1
        target_filename = form_exercise_1_file_name(sequence_number, 'Collected-Data', 'csv')
        source_file_name = 'data/__generate_synthetic_data/template_files/data_template.csv'
        clone_file(source_file_name, batch_directory_name, target_filename)

    for i in range(35):
        sequence_number += 1
        target_filename = form_exercise_1_file_name(sequence_number, 'Collected-Data', 'xml')
        source_file_name = 'data/__generate_synthetic_data/template_files/data_template.xml'
        clone_file(source_file_name, batch_directory_name, target_filename)

    for i in range(75):
        sequence_number += 1
        target_filename = form_exercise_1_file_name(sequence_number, 'Collected-Image', 'jp2')
        source_file_name = 'data/__generate_synthetic_data/template_files/image_template.jp2'
        clone_file(source_file_name, batch_directory_name, target_filename)

    for i in range(11):
        sequence_number += 1
        target_filename = form_exercise_1_file_name(sequence_number, 'PROGRAM', 'py')
        source_file_name = 'data/__generate_synthetic_data/template_files/template_python_program.py'
        clone_file(source_file_name, batch_directory_name, target_filename)

    for i in range(5):
        sequence_number += 1
        target_filename = form_exercise_1_file_name(sequence_number, 'Notebook', 'ipynb')
        source_file_name = 'data/__generate_synthetic_data/template_files/template_notebook.ipynb'
        clone_file(source_file_name, batch_directory_name, target_filename)

    return sequence_number + 1


def create_batch_2_files(first_sequence_number):
    batch_directory_name = 'data/__generate_synthetic_data/exercise_1/batch_2'
    delete_directory(batch_directory_name)
    create_directory(batch_directory_name)

    sequence_number = first_sequence_number
    for i in range(60):
        sequence_number += 1
        target_filename = form_exercise_1_file_name(sequence_number, 'Collected-Data', 'csv')
        source_file_name = 'data/__generate_synthetic_data/template_files/data_template.csv'
        clone_file(source_file_name, batch_directory_name, target_filename)

    for i in range(25):
        sequence_number += 1
        target_filename = form_exercise_1_file_name(sequence_number, 'Collected-Data', 'xml')
        source_file_name = 'data/__generate_synthetic_data/template_files/data_template.xml'
        clone_file(source_file_name, batch_directory_name, target_filename)

    for i in range(80):
        sequence_number += 1
        target_filename = form_exercise_1_file_name(sequence_number, 'Collected-Image', 'jp2')
        source_file_name = 'data/__generate_synthetic_data/template_files/image_template.jp2'
        clone_file(source_file_name, batch_directory_name, target_filename)

    for i in range(8):
        sequence_number += 1
        target_filename = form_exercise_1_file_name(sequence_number, 'PROGRAM', 'py')
        source_file_name = 'data/__generate_synthetic_data/template_files/template_python_program.py'
        clone_file(source_file_name, batch_directory_name, target_filename)

    for i in range(3):
        sequence_number += 1
        target_filename = form_exercise_1_file_name(sequence_number, 'Notebook', 'ipynb')
        source_file_name = 'data/__generate_synthetic_data/template_files/template_notebook.ipynb'
        clone_file(source_file_name, batch_directory_name, target_filename)

    return sequence_number + 1


def form_tutorial_file_name(sequence_number, description, file_extension):
    result = (f'{get_random_project_name()} {description}  {get_random_data_source()}  '
              f'{format_style_a_sequence_number(sequence_number)}.{file_extension}')
    return result


def form_exercise_1_file_name(sequence_number, description, file_extension):
    result = (f'{get_random_data_source()} {get_random_project_name()} {description}  '
              f'{format_style_b_sequence_number(sequence_number)}.{file_extension}')
    return result


if __name__ == '__main__':
    main()
